#include <cassert>

inline Circunferencia::Circunferencia(Posicao const& posicao, int raio)
    : Forma(posicao), raio_(raio) 
{
    assert(0 <= raio);

    assert(cumpreInvariante());
    assert(this->posicao() == posicao);
    assert(this->raio() == raio);
}

inline int Circunferencia::raio() const 
{
    assert(cumpreInvariante());

    return raio_;
}

inline bool Circunferencia::cumpreInvariante() const 
{
    return 0 <= raio_;
}
