#ifndef COR_H
#define COR_H

/** Representa as cores de um quadro preto e branco. */
enum PretoEBranco {preto, branco};

/** Devolve a cor que contrasta com cor.
    @pre V.
    @post (cor = preto e contrasta = branco) ou 
          (cor = branco e contrasta = preto). */
PretoEBranco contrasta(PretoEBranco const cor);

/** Devolve um caracter que represente aproximadamente a cor num ecr
    em modo texto.
    @pre V.
    @post (cor = branco e caractere = ' ') ou (cor = preto e caractere = ''.*/
char caractere(PretoEBranco const cor);

#include "cor_impl.H"

#endif // COR_H

