#ifndef DIMENSAO_H
#define DIMENSAO_H

/** Representa uma dimenso no ecr.
    @invariant 0 <= numero_de_linhas e 0 <= numero_de_colunas. */
class Dimensao {
public:
    /** Constri nova dimenso.
        @pre 0 <= numero_de_linhas e 0 <= numero_de_colunas.
        @post numeroDeLinhas() = numero_de_linhas e
              numeroDeColunas() = numero_de_colunas. */
    Dimensao(int const numero_de_linhas = 0, int const numerdo_de_colunas = 0);

    /** Devolve o nmero de linhas.
        @pre V.
        @post numeroDeLinhas = nmero de linhas. */
    int numeroDeLinhas() const;

    /** Devolve o nmero de colunas.
        @pre V.
        @post numeroDeColunas = nmero de colunas. */
    int numeroDeColunas() const;

private:
    int numero_de_linhas;
    int numero_de_colunas;

    /** Indica se a condio invariante da classe se verifica.
        @pre V.
        @post cumpreInvariante = 0 <= numero_de_linhas e 
                                 0 <= numero_de_colunas. */
    bool cumpreInvariante() const;
};

/** Indica se duas dimenses so iguais.
    @pre V.
    @post operator== = (uma_dimensao.numeroDeLinhas() = 
                        outra_dimensao.numeroDeLinhas() e
                        uma_dimensao.numeroDeColunas() = 
                        outra_dimensao.numeroDeColunas()) .*/
bool operator==(Dimensao const& uma_dimensao, Dimensao const& outra_dimensao);

#include "dimensao_impl.H"

#endif // DIMENSAO_H
