#include <cassert>

inline Dimensao::Dimensao(int const numero_de_linhas, 
			  int const numero_de_colunas)
    : numero_de_linhas(numero_de_linhas), 
      numero_de_colunas(numero_de_colunas) 
{
    assert(0 <= numero_de_linhas and 0 <= numero_de_colunas);

    assert(cumpreInvariante());
    assert(numeroDeLinhas() == numero_de_linhas);
    assert(numeroDeColunas() == numero_de_colunas);
}

inline int Dimensao::numeroDeLinhas() const 
{
    assert(cumpreInvariante());

    return numero_de_linhas;
}

inline int Dimensao::numeroDeColunas() const 
{
    assert(cumpreInvariante());

    return numero_de_colunas;
}

inline bool Dimensao::cumpreInvariante() const
{
    return 0 <= numero_de_linhas and 0 <= numero_de_colunas;
}

inline bool operator==(Dimensao const& uma_dimensao, 
		       Dimensao const& outra_dimensao)
{
    return uma_dimensao.numeroDeLinhas() == outra_dimensao.numeroDeLinhas() and
	uma_dimensao.numeroDeColunas() == outra_dimensao.numeroDeColunas();
}
