#ifndef FORMA_H
#define FORMA_H

#include "quadro.H"

/** Representa o conceito de forma como algo que tem uma posio, que se pode
    mover, e que se sabe desenhar num quadro. 
    @invariant V. */
class Forma {
public:
    /** Constri uma forma dada uma posio.
        @pre V.
        @post posicao() = posicao. */
    Forma(Posicao const& posicao);

    /** Destrutor virtual.  Garante que os destrutores das classes derivadas
        so invocados mesmo atravs dum ponteiro para a classe Forma.
        @pre V. */
    virtual ~Forma() = 0;

    /** Devolve a posio da forma.
        @pre V.
        @post posicao = posio da forma. */
    Posicao posicao() const;

    /** Desenha a forma num quadro.
        @pre V.
        @post quadro est pintado na zona correspondente  forma. */
    virtual void desenhaEm(Quadro& quadro) const = 0;

    /** Desloca a forma para nova posio.
        @pre V.
        @post posicao() = nova_posicao. */
    virtual void movePara(Posicao const& nova_posicao);

private:
    // A posio da forma (um ponto particular, como um centro ou canto):
    Posicao posicao_;

    /** Indica se a condio invariante da classe se verifica.
        @pre V.
        @post cumpreInvariante = V. */
    bool cumpreInvariante() const;
};

#include "forma_impl.H"

#endif // FORMA_H
