#include <cassert>

inline Forma::Forma(Posicao const& posicao)
    : posicao_(posicao) 
{

    assert(cumpreInvariante());
    assert(this->posicao() == posicao);
}

inline Forma::~Forma()
{
    assert(cumpreInvariante());

}

inline Posicao Forma::posicao() const 
{
    assert(cumpreInvariante());

    return posicao_;
}

inline void Forma::movePara(Posicao const& nova_posicao) 
{
    assert(cumpreInvariante());

    posicao_ = nova_posicao;

    assert(cumpreInvariante());
    assert(posicao() == nova_posicao);
}

inline bool Forma::cumpreInvariante() const
{
    return true;
}
