#ifndef POSICAO_H
#define POSICAO_H

/** Representa uma posio.
    @invariant V. */
class Posicao {
  public:
    /** Constri uma nova posio.
        @pre V.
        @post linha() = linha e coluna() = coluna. */
    Posicao(int const linha = 0, int const coluna = 0);

    /** Devolve a linha.
        @pre V.
        @post linha = linha da posio. */
    int linha() const;

    /** Devolve a coluna.
        @pre V.
        @post coluna = coluna da posio. */
    int coluna() const;

  private:
    int linha_;
    int coluna_;

    /** Indica se a condio invariante da classe se verifica.
        @pre V.
        @post V. */
    bool cumpreInvariante() const;
};

/** Indica se duas posies so iguais.
    @pre V.
    @post operator== = (uma_posicao.linha() = outra_posicao.linha() e
                        uma_posicao.coluna() = outra_posicao.coluna()) .*/
bool operator==(Posicao const& uma_posicao, Posicao const& outra_posicao);

#include "posicao_impl.H"

#endif // POSICAO_H
