inline Posicao::Posicao(int const linha, int const coluna)
    : linha_(linha), coluna_(coluna) 
{

    assert(cumpreInvariante());
    assert(this->linha() == linha);
    assert(this->coluna() == coluna);
}

inline int Posicao::linha() const 
{
    assert(cumpreInvariante());

    return linha_;
}

inline int Posicao::coluna() const 
{
    assert(cumpreInvariante());

    return coluna_;
}

inline bool Posicao::cumpreInvariante() const 
{
    return true;
}

inline bool operator==(Posicao const& uma_posicao, 
		       Posicao const& outra_posicao)
{
    return uma_posicao.linha() == outra_posicao.linha() and
	uma_posicao.coluna() == outra_posicao.coluna();
}
