#include "quadrado.H"

#include "util.H"

/* Desenha o quadrado no quadro q, compensando pxeis com relao
   largura/altura quadro.aspecto(): */
void Quadrado::desenhaEm(Quadro& quadro) const 
{
    assert(cumpreInvariante());

    // Posio do quadrado:
    int l = posicao().linha();
    int c = posicao().coluna();
    int altura = arredonda<int>(lado() * quadro.aspecto());

    // Desenho dos lados horizontais:
    for(int i = 0; i != lado() - 1; ++i) {
        quadro.pinta(Posicao(l, c + i));
        // Altura compensada pelo rcio largura/altura dos pxeis:
        quadro.pinta(Posicao(l + altura - 1, c + 1 + i));
    }

    // Desenho dos lados verticais (altura compensada pelo rcio
    // largura/altura dos pxeis):
    for(int i = 0; i != altura - 1; ++i) {
        quadro.pinta(Posicao(l + 1 + i, c));
        quadro.pinta(Posicao(l + i, c + lado() - 1));
    }
}
