#ifndef QUADRADO_H
#define QUADRADO_H

#include "forma.H"

/** Representa um quadrado aberto com lados paralelos aos eixos
    coordenados.  Posio  o canto superior direito.
    @invariant 0 <= lado. */
class Quadrado : public Forma {
public:
    /** Constri novo quadrado dadas a posio do canto superior esquerdo
        e a dimenso do lado (em colunas do quadro).
        @pre V.
        @post posicao() = posicao e lado() = lado. */
    Quadrado(Posicao const& posicao, int lado);

    /** Destrutor virtual.  Garante que os destrutores das classes
        derivadas so invocados mesmo atravs dum ponteiro para a
        classe Quadrado.
        @pre V. */
    ~Quadrado() {}

    /** Devolve dimenso do lado (em colunas do quadro).
        @pre V.
        @post lado = lado do quadrado. */
    int lado() const;

    /** Desenha o quadrado no quadro, compensando o facto dos pxeis serem
        rectangulares.
        @pre V.
        @post quadro est pintado na zona correspondente ao quadrado. */
    virtual void desenhaEm(Quadro& quadro) const;  

private:
    // Dimenso do lado (em colunas):
    int lado_;

    /** Indica se a condio invariante de classe se verifica.
        @pre V.
        @post cumpreInvariante = 0 <= lado. */
    bool cumpreInvariante() const;
};

#include "quadrado_impl.H"

#endif // QUADRADO_H
