inline Quadrado::Quadrado(Posicao const& posicao, int lado)
    : Forma(posicao), lado_(lado) 
{
    assert(0 <= lado);

    assert(cumpreInvariante());
    assert(this->posicao() == posicao);
    assert(this->lado() == lado);
}

inline int Quadrado::lado() const 
{
    assert(cumpreInvariante());

    return lado_;
}

inline bool Quadrado::cumpreInvariante() const 
{
    return 0 <= lado_;
}
