#include <cassert>

inline Quadro::Quadro(Dimensao const& dimensao, Cor const fundo, 
		      double const aspecto)
    : dimensao_(dimensao), fundo_(fundo), aspecto_(aspecto),
      pixeis(dimensao.numeroDeLinhas(), 
	     std::vector<Cor>(dimensao.numeroDeColunas(), fundo))
{
    assert(0 < dimensao.numeroDeLinhas());
    assert(0 < dimensao.numeroDeColunas());
    assert(0.0 <= aspecto);

    assert(cumpreInvariante());
    assert(this->dimensao() == dimensao);
    assert(this->fundo() == fundo);
    assert(this->aspecto() == aspecto);
}

inline void Quadro::pinta(Posicao const& posicao, Cor const cor_a_usar) 
{
    assert(cumpreInvariante());

    if(inclui(posicao))
        pixeis[posicao.linha()][posicao.coluna()] = cor_a_usar;

    assert(cumpreInvariante());
    assert(not inclui(posicao) or cor(posicao) == cor_a_usar);
}

inline void Quadro::pinta(Posicao const& posicao) 
{
    assert(cumpreInvariante());

    if(inclui(posicao))
        pixeis[posicao.linha()][posicao.coluna()] = contrasta(fundo());

    assert(cumpreInvariante());
    assert(not inclui(posicao) or cor(posicao) != fundo());
}

inline void Quadro::limpa(Posicao const& posicao) 
{
    assert(cumpreInvariante());

    pinta(posicao, fundo());

    assert(cumpreInvariante());
    assert(cor(posicao) == fundo());
}

inline Quadro::Cor Quadro::cor(Posicao const& posicao) const 
{
    assert(cumpreInvariante());

    return inclui(posicao) ? 
	pixeis[posicao.linha()][posicao.coluna()] : fundo();
}

inline bool Quadro::inclui(Posicao const& posicao) const 
{
    assert(cumpreInvariante());

    return (0 <= posicao.linha() and 
	    posicao.linha() < dimensao().numeroDeLinhas() and
            0 <= posicao.coluna() and 
	    posicao.coluna() < dimensao().numeroDeColunas());
}

inline Quadro::Cor Quadro::fundo() const 
{
    assert(cumpreInvariante());

    return fundo_;
}

inline double Quadro::aspecto() const 
{
    assert(cumpreInvariante());

    return aspecto_;
}

inline Dimensao Quadro::dimensao() const 
{
    assert(cumpreInvariante());

    return dimensao_;
}

inline bool Quadro::cumpreInvariante() const
{
    if(dimensao_.numeroDeLinhas() <= 0 or dimensao_.numeroDeColunas() <= 0 or
       aspecto_ <= 0.0 or int(pixeis.size()) != dimensao_.numeroDeLinhas())
	return false;

    for(std::vector<std::vector<Cor> >::size_type i = 0; i != pixeis.size(); 
	++i)
	if(int(pixeis[i].size()) != dimensao_.numeroDeColunas())
	    return false;

    return true;
}
