// Corra numa consola com 24 linhas por 80 colunas!

#include <cstdlib> // para rand().
#include <list>

using namespace std;

#include "quadro.H"
#include "quadrado.H"
#include "circunferencia.H"

int main()
{
    int const linhas = 24;
    int const colunas = 80;

    Quadro quadro(Dimensao(linhas, colunas), preto, 0.5);

    list<Forma*> lista;
    for(int i = 0; i != 10; ++i) {
        int l = rand() % linhas;
        int c = rand() % colunas;
        lista.push_back(new Quadrado(Posicao(l, c), rand() % 15 + 1));
        l = rand() % linhas;
        c = rand() % colunas;
        lista.push_back(new Circunferencia(Posicao(l, c), rand() % 7 + 1));
    }

    for(list<Forma*>::iterator i = lista.begin(); i != lista.end(); ++i) {
        (*i)->desenhaEm(quadro);
        quadro.mostraEm(cout);
        cin.get();
	quadro.apaga();
    }

    for(list<Forma*>::iterator i = lista.begin(); i != lista.end(); ++i)
	delete *i;
}
